﻿using UnityEditor;
using UnityEditor.Build.Reporting;
using UnityEngine;

public static class Build 
{
    // Start is called before the first frame update
    public static void BuildiOS()
    {
        var options = new BuildPlayerOptions();
        options.scenes = new[] { "Assets/Scenes/Menu.unity", "Assets/Scenes/Level1.unity", "Assets/Scenes/Level2.unity", "Assets/Scenes/Level3.unity", "Assets/Scenes/Level4.unity" };
        options.locationPathName = "../iOS Build";
        options.target = BuildTarget.iOS;
        options.options = BuildOptions.None;

        var report = BuildPipeline.BuildPlayer(options);
        var summary = report.summary;

        if (summary.result == BuildResult.Succeeded)
        {
            Debug.Log("Build succeeded: " + summary.totalSize + " bytes");
        } 
        else if (summary.result == BuildResult.Failed)
        {
            Debug.Log("Build failed");
        }
    }
}
